import ctypes
import importlib
import sys
import time
import traceback

import bpy
import atexit
from . import core
from . import ops
from . import ui

bl_info = {
    "name": "REBOCAP BLENDER PLUGIN",
    "author": "Rebocap",
    "description": "",
    "blender": (3, 6, 0),
    "version": (0, 0, '0 (BETA)'),
    "location": "",
    "warning": "",
    "doc_url": "https://doc.rebocap.com/zh_cn/plugins/blender.html",
    "tracker_url": "https://doc.rebocap.com/zh_cn/plugins/blender.html",
    "category": "Rebocap"
}

class_list = [
    ops.RebocapConnect,
    ops.RebocapDisconnect,
    ops.RebocapStartRecord,
    ops.RebocapStopRecord,
    ops.AutoMapBone,
    ops.SaveBone,
    core.RebocapBones,
    ui.ConnectionPanel,
    ui.PickBoneOperator,
]

joints = [
    "m_avg_Pelvis", "m_avg_L_Hip", "m_avg_R_Hip", "m_avg_Spine1", "m_avg_L_Knee", "m_avg_R_Knee",
    "m_avg_Spine2", "m_avg_L_Ankle", "m_avg_R_Ankle", "m_avg_Spine3", "m_avg_L_Foot", "m_avg_R_Foot",
    "m_avg_Neck", "m_avg_L_Collar", "m_avg_R_Collar", "m_avg_Head", "m_avg_L_Shoulder", "m_avg_R_Shoulder",
    "m_avg_L_Elbow", "m_avg_R_Elbow", "m_avg_L_Wrist", "m_avg_R_Wrist", "m_avg_L_Hand", "m_avg_R_Hand",
]

pyd_module = None
done_module_release = None
register_ts = time.time()


@bpy.app.handlers.persistent
def reset_property_values(_):
    bpy.context.scene.open = False
    bpy.context.scene.recording = False
    # bind_bones = bpy.context.scene.bind_bones
    # bind_bones.clear()
    # for i in range(len(joints)):
    #     bone = bind_bones.add()
    #     bone.key = REBOCAP_JOINT_NAMES[i]
    #     bone.value = joints[i]


def register():
    global done_module_release, pyd_module, register_ts
    print("start register rebocap!", flush=True)
    from .rebocap_api.rebocap_ws_sdk import REBOCAP_JOINT_NAMES, my_pyd_module
    """
    if done_module_release is not None:
        print(f"start load module:{done_module_release}")
        res = importlib.reload(done_module_release)
        print(f'suc reload module:{done_module_release} status:{res}', flush=True)
    """

    pyd_module = my_pyd_module
    bpy.app.handlers.load_post.append(reset_property_values)
    ops.init_rebocap_api()
    for item in class_list:
        bpy.utils.register_class(item)

    core.register_types()
    done_module_release = None
    register_ts = time.time()


def cleanup():
    global done_module_release
    if pyd_module is None:
        return

    ops.uninit_rebocap_api()
    return
    target_modules = []
    for e in sys.modules:
        if 'rebocap_ws_sdk_ext' in e:
            target_modules.append(e)

    for target_module in target_modules:
        module = sys.modules.get(target_module)
        if not module:
            print(f"Module '{target_module}' not found in sys.modules", flush=True)
            return

        # 获取模块的文件路径
        module_path = getattr(module, '__file__', None)
        if not module_path:
            print(f"Module '{target_module}' has no __file__ attribute", flush=True)
            return

        # 将文件路径转换为宽字符字符串（Windows API 需要）
        module_path_wide = ctypes.c_wchar_p(module_path)

        # 获取模块句柄
        kernel32 = ctypes.WinDLL('kernel32', use_last_error=True)
        get_module_handle = kernel32.GetModuleHandleW
        get_module_handle.argtypes = [ctypes.c_wchar_p]
        get_module_handle.restype = ctypes.c_void_p

        handle = get_module_handle(module_path_wide)
        if not handle:
            print(f"Failed to get handle for module '{target_module}'", flush=True)
            return

        # 卸载模块
        free_library = kernel32.FreeLibrary
        free_library.argtypes = [ctypes.c_void_p]
        free_library.restype = ctypes.c_int

        if free_library(handle):
            print(f"Successfully unloaded module for rebocap '{target_module}'", flush=True)
            # del sys.modules[target_module]  # 从 sys.modules 中移除
            done_module_release = module
        else:
            print(f"Failed to unload module '{target_module}'", flush=True)


def unregister():
    print("unregister rebocap!", flush=True)
    if reset_property_values in bpy.app.handlers.load_post:
        bpy.app.handlers.load_post.remove(reset_property_values)

    if time.time() - register_ts > 2.0:
        cleanup()

    for item in class_list:
        bpy.utils.unregister_class(item)
