import bpy


class AutoMapBone(bpy.types.Operator):
    bl_idname = 'rebocap.auto_map_bone'
    bl_label = 'Auto Map Bone'

    @classmethod
    def poll(cls, ctx):
        return bpy.data.objects.get(ctx.active_object.rebocap_source_armature) != None

    def execute(self, ctx):
        all_names = ('hips', 'spine', 'chest', 'upperChest', 'neck', 'head', 'leftEye', 'rightEye', 'jaw', 'leftUpperLeg', 'leftLowerLeg', 'leftFoot', 'leftToes', 'rightUpperLeg', 'rightLowerLeg', 'rightFoot', 'rightToes', 'leftShoulder', 'leftUpperArm', 'leftLowerArm', 'leftHand', 'rightShoulder', 'rightUpperArm', 'rightLowerArm', 'rightHand', 'leftThumbProximal', 'leftThumbIntermediate', 'leftThumbDistal', 'leftIndexProximal', 'leftIndexIntermediate', 'leftIndexDistal', 'leftMiddleProximal', 'leftMiddleIntermediate', 'leftMiddleDistal', 'leftRingProximal', 'leftRingIntermediate', 'leftRingDistal', 'leftLittleProximal', 'leftLittleIntermediate', 'leftLittleDistal', 'rightThumbProximal', 'rightThumbIntermediate', 'rightThumbDistal', 'rightIndexProximal', 'rightIndexIntermediate', 'rightIndexDistal', 'rightMiddleProximal', 'rightMiddleIntermediate', 'rightMiddleDistal', 'rightRingProximal', 'rightRingIntermediate', 'rightRingDistal', 'rightLittleProximal', 'rightLittleIntermediate', 'rightLittleDistal')
        required_names = ('hips', 'spine', 'chest', 'neck', 'head', 'leftUpperLeg', 'leftLowerLeg', 'leftFoot', 'rightUpperLeg', 'rightLowerLeg', 'rightFoot', 'leftUpperArm', 'leftLowerArm', 'leftHand', 'rightUpperArm', 'rightLowerArm', 'rightHand')
        optional_names = ('upperChest', 'leftEye', 'rightEye', 'jaw', 'leftToes', 'rightToes', 'leftShoulder', 'rightShoulder', 'leftThumbProximal', 'leftThumbIntermediate', 'leftThumbDistal', 'leftIndexProximal', 'leftIndexIntermediate', 'leftIndexDistal', 'leftMiddleProximal', 'leftMiddleIntermediate', 'leftMiddleDistal', 'leftRingProximal', 'leftRingIntermediate', 'leftRingDistal', 'leftLittleProximal', 'leftLittleIntermediate', 'leftLittleDistal', 'rightThumbProximal', 'rightThumbIntermediate', 'rightThumbDistal', 'rightIndexProximal', 'rightIndexIntermediate', 'rightIndexDistal', 'rightMiddleProximal', 'rightMiddleIntermediate', 'rightMiddleDistal', 'rightRingProximal', 'rightRingIntermediate', 'rightRingDistal', 'rightLittleProximal', 'rightLittleIntermediate', 'rightLittleDistal')

        self.bones = [
            "Pelvis", "L_UpLeg", "R_UpLeg", "Spine", "L_DownLeg", "R_DownLeg",
            "Chest", "L_Foot", "R_Foot", "UpChest", "L_Toe", "R_Toe",
            "Neck", "L_Shoulder", "R_Shoulder", "Head", "L_UpArm", "R_UpArm",
            "L_DownArm", "R_DownArm", "L_Palm", "R_Palm", "L_Fingers", "R_Fingers",
        ]
        vrm_bone_list = ['hips', 'leftUpperLeg', 'rightUpperLeg', 'spine', 'leftLowerLeg', 'rightLowerLeg',
                         'chest', 'leftFoot', 'rightFoot', 'upperChest', 'leftToes', 'rightToes',
                         'neck', 'leftShoulder', 'rightShoulder', 'head', 'leftUpperArm', 'rightUpperArm',
                         'leftLowerArm', 'rightLowerArm', 'leftHand', 'rightHand']
        source = bpy.data.objects.get(ctx.active_object.rebocap_source_armature)
        if source and source.type == 'ARMATURE':
            armature_data = source.data
            if hasattr(armature_data, 'vrm_addon_extension'):
                mappings = {}
                for human_bone in armature_data.vrm_addon_extension.vrm0.humanoid.human_bones:
                    if human_bone.bone not in all_names:
                        continue
                    if not human_bone.node.bone_name:
                        continue
                    mappings[human_bone.bone] = human_bone.node.bone_name
                rebocap_bone_map = ctx.scene.rebocap_bone_map
                for i in range(22):
                    if vrm_bone_list[i] in mappings:
                        setattr(rebocap_bone_map, f'node_{i}', mappings[vrm_bone_list[i]])
                    else:
                        setattr(rebocap_bone_map, f'node_{i}', '')

        return {'FINISHED'}
